	TITLE Geometry Library Main Module

INCLUDE GEROMID.H
INCLUDE GEEXTDEC.H

*****************************************************************
* The main module contains the dispatchees of the user words.
* Each routine is named with a NULLNAME compiler directive, and
* has a corresponding entry in the external declarations file.
*****************************************************************
NULLNAME GEDoACone ( %radius %height --> %area )
* Calculates the area of a cone given its radius and height
::
  DUP %* OVER DUP %*            ( r h^2 r^2 --> )
  DUPROT %+ %SQRT               ( r r^2 SQRT[r^2+h^2] --> )
  ROT GEtimesPI %*              ( r^2 PI*r*SQRT[r^2+h^2] --> )
  SWAP GEtimesPI %+             ( %area )
;
*****************************************************************
NULLNAME GEDoVCone ( %radius %height --> %volume )
* Calculates the volume of a cone given its radius and height
::
  OVER %* %*
  GEtimesPI %3 %/
;
*****************************************************************
